function cor = corrcoef(obj, in)
%CORRCOEF Calculates the correlation coefficient between all elements of obj and an input in
% the output cor is a struct with the same structure as obj, only with the
% correlation coefficients between obj and in.
% It is assumed that in has the same size as the DynamicElements in obj

    cor = struct;

    % Get correlation with states, auxStates, controls, and inputs
    cor.x = corElement(obj, 'x', in);
    cor.a = corElement(obj, 'a', in);
    cor.u = corElement(obj, 'u', in);
    cor.d = corElement(obj, 'd', in);
 
    % get correlation with time
    inputName = fields(obj.d);
    corMatrix = corrcoef(obj.d.(inputName{1}).val(:,1), in);
    cor.t = corMatrix(1,2);
end

function cor = corElement(obj, element, in)
% calculate the correlation coefficients for one of the elements of obj
% element: 'x', 'a', 'c', or 'd', i.e.,
%           states, auxStates, controls, or inputs
    names = fields(obj.(element));

    for k=1:length(names)
        corMatrix = corrcoef(obj.(element).(names{k}).val(:,2), in);
        cor.(names{k}) = corMatrix(1,2);
    end
end

